 ; Ŀ
 ;   Cf - vertically orient text entities between horizontal lines.        
 ;   Copyright 2000, 2002, 2005, 2008, 2010 by Rocket Software Ltd.        
 ;   Rocket - the only software with built-in enthusiasm.                  
 ; 

 ; Ŀ
 ;   Cron - returns the corners of a text entity.                          
 ;   Arguments: Enam, a text entity ename.                                 
 ;              Offdis, the offset distance.                               
 ;   Rewritten 2010.10.10.                                                 
 ; 
 (DEFUN CRON (enam offdis / aa bb rota cc dd bheigt bwidth llangg lldist ll ul
                                                    lr ur xmax xmin ymax ymin)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assumining that the  
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
 ; Ŀ
 ;   Extract the real corner points of the text.                           
 ; 
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   Find the maximum and minimum X and Y points.  These may not be the    
 ;   same as the corners of the text box, since the text may be rotated.   
 ; 
  (setq xmax (max (car ul) (car ll) (car ur) (car lr)))
  (setq xmin (min (car ul) (car ll) (car ur) (car lr)))
  (setq ymax (max (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq ymin (min (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq xmax (+ xmax offdis))
  (setq xmin (- xmin offdis))
  (setq ymax (+ ymax offdis))
  (setq ymin (- ymin offdis))
 ; Ŀ
 ;   And return the max and min x and y list.                              
 ; 
 (list xmax xmin ymax ymin))
 ; Ŀ
 ;   Cron end.                                                             
 ; 

 ; Ŀ
 ;   Grout - Text/Attdef grdraw outliner.                                  
 ;   Arguments: SS, a selection set of textlike things.                    
 ;              Gbox, the grdraw colour, if nil then don't draw a box.     
 ;              Offdis, the offset distance for text.                      
 ;   Returns a list of four corner points, cw from top left.               
 ;   Rewritten 2010.10.10 to take Offdis as an argument.                   
 ; 
 (DEFUN GROUT (ss gbox offdis / num enam typ entt mxlst xmax xmin ymax ymin
                                                                ul ur lr ll)
  (setq num 0)
 ; Ŀ
 ;   Process selection set.                                                
 ; 
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (itoa (setq num (1+ num))))
         (setq typ (cdr (assoc 0 (entget enam))))
         (if (= typ "INSERT")
             (while (/= (setq typ (cdr (assoc 0 (setq entt (entget
                                                (setq enam (entnext enam)))))))
                        "SEQEND")
                    (if (and (= typ "ATTRIB")
                             (/= (cdr (assoc 1 entt)) "")
                             (/= (cdr (assoc 1 entt)) " "))
                        (progn
                             (setq mxlst (cron enam offdis))
                             (if xmax
                                 (setq xmax (max xmax (car mxlst)))
                                 (setq xmax (car mxlst)))
                             (if xmin
                                 (setq xmin (min xmin (cadr mxlst)))
                                 (setq xmin (cadr mxlst)))
                             (if ymax
                                 (setq ymax (max ymax (caddr mxlst)))
                                 (setq ymax (caddr mxlst)))
                             (if ymin
                                 (setq ymin (min ymin (cadddr mxlst)))
                                 (setq ymin (cadddr mxlst)))))))
         (if (or (= typ "TEXT") (= typ "ATTDEF"))
             (progn
                  (setq mxlst (cron enam 0))
                  (if xmax
                      (setq xmax (max xmax (car mxlst)))
                      (setq xmax (car mxlst)))
                  (if xmin
                      (setq xmin (min xmin (cadr mxlst)))
                      (setq xmin (cadr mxlst)))
                  (if ymax
                      (setq ymax (max ymax (caddr mxlst)))
                      (setq ymax (caddr mxlst)))
                  (if ymin
                      (setq ymin (min ymin (cadddr mxlst)))
                      (setq ymin (cadddr mxlst))))))
 ; Ŀ
 ;   Make the corner point coordinates.                                    
 ; 
  (setq ul (list xmin ymax))
  (setq ur (list xmax ymax))
  (setq lr (list xmax ymin))
  (setq ll (list xmin ymin))
 ; Ŀ
 ;   Now draw the polyline around the outer extent points.                 
 ; 
  (if gbox
      (progn
           (grdraw ul ur gbox)
           (grdraw ur lr gbox)
           (grdraw lr ll gbox)
           (grdraw ll ul gbox)))
 (list ul ur lr ll))
 ; Ŀ
 ;   Grout end.                                                            
 ; 

 ; Ŀ
 ;   Justx - returns a string describing the justification of the text     
 ;   entity whose data was passed as its sole argument.                    
 ; 
 (DEFUN JUSTX (entt / xjust yjust xjst yjst justrg)
  (setq xjust (cdr (assoc 72 entt)))
  (if (= (cdr (assoc 0 entt)) "TEXT")
      (setq yjust (cdr (assoc 73 entt)))
      (setq yjust (cdr (assoc 74 entt))))
 ; Ŀ
 ;   Vertical justification.                                               
 ; 
  (cond ((= yjust 0) (setq yjst ""))       ; base = normal
        ((= yjust 1) (setq yjst "B"))      ; bottom
        ((= yjust 2) (setq yjst "M"))      ; middle
        ((= yjust 3) (setq yjst "T"))      ; top
        (T           (setq yjst "")))      ; default
 ; Ŀ
 ;   Horizontal justification.                                             
 ; 
  (cond ((= xjust 0) (setq xjst "L"))      ; left
        ((= xjust 1) (setq xjst "C"))      ; centre
        ((= xjust 2) (setq xjst "R"))      ; right
        ((= xjust 3) (setq xjst "A"))      ; aligned
        ((= xjust 4) (setq xjst "M"))      ; middle
        ((= xjust 5) (setq xjst "F"))      ; fit
        (T           (setq xjst "L")))     ; default
  (setq justrg (strcat yjst xjst)))
 ; Ŀ
 ;   Justx end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Mill - middle rejustify an ss of text/attdefs.             
 ;   Arguments: ss, the selection set of text and attdefs.                 
 ;   Calls the said routine, returns nothing.                              
 ; 
 (DEFUN MILL (ss / num enam just)
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq just (justx (entget enam)))
         (cond ((= (substr just 1 1) "M"))
               ((= just "L")
                (mlrj enam))
               ((= just "R")
                (mrrj enam))))
 (princ))
 ; Ŀ
 ;   Subroutine Mill end.                                                  
 ; 

 ; Ŀ
 ;   Mrrj - middle right rejustify a text or attdef entity, preserve the   
 ;   location.                                                             
 ; 
 (DEFUN MRRJ (enam / entt typ pta pa pta1 p11 ydis new11)
  (setq entt (entget enam))
  (setq typ (cdr (assoc 0 entt)))
  (setq pta (cdr (assoc 10 entt)))
  (if (= typ "TEXT")
      (if (assoc 73 entt)
          (setq entt (subst (cons 73 2) (assoc 73 entt) entt))
          (setq entt (append entt (list (cons 73 2)))))
      (if (assoc 74 entt)
          (setq entt (subst (cons 74 2) (assoc 74 entt) entt))
          (setq entt (append entt (list (cons 74 2))))))
  (entmod (setq entt (subst (cons 72 2) (assoc 72 entt) entt)))
  (setq entt (entget enam))
  (setq pta1 (cdr (assoc 10 entt)))
  (setq p11 (cdr (assoc 11 entt)))
  (setq xdis (- (car pta) (car pta1)))
  (setq ydis (- (cadr pta) (cadr pta1)))
  (setq new11 (list (+ (car p11) xdis) (+ (cadr p11) ydis) (caddr p11)))
  (entmod (subst (cons 11 new11) (assoc 11 entt) entt))
 (princ))
 ; Ŀ
 ;   Mrrj end.                                                             
 ; 

 ; Ŀ
 ;   MLrj - middle left rejustify a text or attdef entity, preserve the    
 ;   location.                                                             
 ; 
 (DEFUN MLRJ (enam / entt typ pta pa pta1 p11 ydis new11)
  (setq entt (entget enam))
  (setq typ (cdr (assoc 0 entt)))
  (setq pta (cdr (assoc 10 entt)))
  (if (= typ "TEXT")
      (if (assoc 73 entt)
          (setq entt (subst (cons 73 2) (assoc 73 entt) entt))
          (setq entt (append entt (list (cons 73 2)))))
      (if (assoc 74 entt)
          (setq entt (subst (cons 74 2) (assoc 74 entt) entt))
          (setq entt (append entt (list (cons 74 2))))))
  (entmod (setq entt (subst (cons 72 0) (assoc 72 entt) entt)))
  (setq entt (entget enam))
  (setq pta1 (cdr (assoc 10 entt)))
  (setq p11 (cdr (assoc 11 entt)))
  (setq xdis (- (car pta) (car pta1)))
  (setq ydis (- (cadr pta) (cadr pta1)))
  (setq new11 (list (+ (car p11) xdis) (+ (cadr p11) ydis) (caddr p11)))
  (entmod (subst (cons 11 new11) (assoc 11 entt) entt))
 (princ))
 ; Ŀ
 ;   MLrj end.                                                             
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   VVB - vertically respace a column of text.                            
 ;   Arguments: Ss - a selection set of text and attdefs.                  
 ;              Yins - the centre point y coordinate.                      
 ;              Incr - the vertical spacing.                               
 ;   Returns nothing.                                                      
 ; 
 (DEFUN VVB (ss yins incr / txa enn nna ya txb yb txh yy nn yins)
  (while (setq txa (ssname ss 0))             ; first entity name
         (setq enn 1)                         ; entity to test - initialize
         (setq nna (entget txa))              ; the whole thing
         (setq ya (cdr (assoc 10 nna)))       ; Y insertion
 ; Ŀ
 ;   Find the highest entity.                                              
 ; 
         (while (setq txb (ssname ss enn))                 ; next entity
                (setq yb (cdr (assoc 10 (entget txb))))    ; Y insertion
                (if (> (cadr yb) (cadr ya))                ; if txb highest
                    (progn
                         (setq txa txb)                    ; next becomes txa
                         (setq nna (entget txa))           ; get whole thing
                         (setq ya (cdr (assoc 10 nna)))))  ; and Y insertion
                (setq enn (1+ enn)))                       ; next entity
 ; Ŀ
 ;   And move it.                                                          
 ; 
         (if (or (= (cdr (assoc 72 nna)) 2)
                 (= (cdr (assoc 72 nna)) 4)
                 (= (cdr (assoc 72 nna)) 1))
             (progn
                   (if (= (cdr (assoc 72 nna)) 4)
                       (progn
                             (setq txh (cdr (assoc 40 (entget (ssname ss 0)))))
                             (setq yy (cdr (assoc 11 nna)))
                             (setq nn (list (car yy) (+ (/ txh 2) yins)))
                             (command "move" txa "" yy nn))
                       (progn
                             (setq yy (cdr (assoc 11 nna)))
                             (setq nn (list (car yy) yins))
                             (command "move" txa "" yy nn))))
             (progn
                   (setq yy (cdr (assoc 10 nna)))
                   (setq nn (list (car yy) yins))
                   (command "move" txa "" yy nn)))
 ; Ŀ
 ;   Increment insertion point, remove entity from ss, loop.               
 ; 
         (setq yins (- yins incr))
         (ssdel txa ss))
 (princ))
 ; Ŀ
 ;   VVB end.                                                              
 ; 

 ; Ŀ
 ;   Cf.                                                                   
 ; 
 (DEFUN C:CF (/ *error* osmo snapp ss ssav cc rr ya incr incrp ptlist um enam
                                                    ptlst curtop curbot curvc)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (defun *error* (shk)
   (if snapp (setvar "snapmode" snapp))
   (if osmo (setvar "osmode" osmo))
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get an ss of text and/or attdefs.                                     
 ; 
  (prompt "Pick text/attdefs to rearrange: ")
  (if (setq ss (ssget '((-4 . "<or")
                        (0 . "text")
                        (0 . "attdef")
                        (-4 . "or>"))))
      (progn
           (setvar "snapmode" snapp)
           (setq ssav (ssget "p"))
 ; Ŀ
 ;   Vertical midpoint coordinate.                                         
 ; 
           (setq cc (getpoint "Top of box: "))
           (if (setq rr (getpoint cc "\n...and bottom or <Return>:"))
               (setq ya (/ (+ (cadr cc) (cadr rr)) 2))
               (setq ya (cadr cc)))
 ; Ŀ
 ;   Line spacing.                                                         
 ; 
           (setq incr (* 1.65 (cdr (assoc 40 (entget (ssname ss 0))))))
           (if (> (sslength ss) 1)
               (setq incrp (getdist cc (strcat "\nLine spacing <"
                                                (rtos incr 2 2) ">:"))))
           (if incrp (setq incr incrp))
 ; Ŀ
 ;   Get the text ss corner points, don't outline the text.                
 ; 
           (setq ptlist (grout ss nil 0))
 ; Ŀ
 ;   It seems reasonable (a dangerous statement in a program) that if we   
 ;   are vertically centring text on a point then it should be middle      
 ;   rejustified if it was left or right justified.                        
 ;   Other justifications are peculiar and are left alone.                 
 ; 
           (mill ss)
 ; Ŀ
 ;   And vertically respace it.                                            
 ; 
           (vvb ss ya incr)
 ; Ŀ
 ;   Save the new text ss corner points, again don't outline it.           
 ; 
           (setq ptlst (grout ssav nil 0))
 ; Ŀ
 ;   Now calculate the current vertical centre of the text ss and move it  
 ;   to the desired vertical centre, Ya.                                   
 ; 
           (setq curtop (cadr (nth 0 ptlst)))
           (setq curbot (cadr (nth 2 ptlst)))
           (setq curvc (/ (+ curtop curbot) 2))
           (command ".move" ssav "" (list 0 curvc) (list 0 ya))))
  (*error* "")
 (princ))